/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.windows;

import com.sshtools.daemon.windows.WindowsAuthentication;
import com.sshtools.daemon.windows.WindowsAuthenticationInfo;
import com.sshtools.daemon.windows.WindowsProcessInfo;
import com.sshtools.daemon.windows.WindowsProcessInputStream;
import com.sshtools.daemon.windows.WindowsProcessOutputStream;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.platform.NativeProcessProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class WindowsProcess
extends NativeProcessProvider {
    private static Logger log;
    WindowsAuthenticationInfo authInfo;
    WindowsProcessInfo processInfo;
    WindowsProcessInputStream input;
    WindowsProcessInputStream error;
    WindowsProcessOutputStream output;
    static /* synthetic */ Class class$com$sshtools$daemon$windows$WindowsProcess;

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public InputStream getStderrInputStream() {
        return this.error;
    }

    public void kill() {
        this.killProcess(this.processInfo);
    }

    public String getDefaultTerminalProvider() {
        return this.getNativeTerminalProvider();
    }

    public boolean supportsPseudoTerminal(String string) {
        return false;
    }

    public boolean allocatePseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) {
        return false;
    }

    public int waitForExitCode() {
        return this.waitForProcessExitCode(this.processInfo.getProcessHandle());
    }

    public boolean stillActive() {
        return this.isProcessActive(this.processInfo.getProcessHandle());
    }

    public void start() throws IOException {
        if (!this.resumeProcess(this.processInfo)) {
            throw new IOException("Process could not be resumed");
        }
    }

    public boolean createProcess(String string, Map map) throws IOException {
        String string2;
        String string3;
        if (!(Thread.currentThread() instanceof SshThread)) {
            log.error((Object)"Calling thread is not an SshThread, failed to read username");
            return false;
        }
        SshThread sshThread = (SshThread)Thread.currentThread();
        if (sshThread.containsProperty("Win32UserAuthInfo")) {
            this.authInfo = (WindowsAuthenticationInfo)sshThread.getProperty("Win32UserAuthInfo");
            WindowsAuthentication windowsAuthentication = (WindowsAuthentication)NativeAuthenticationProvider.getInstance();
            string3 = "";
            String string4 = sshThread.getUsername();
            string2 = windowsAuthentication.getHomeDirectory(string4);
            if (string2 == null || string2.trim().equals("")) {
                string2 = windowsAuthentication.getNativeProfileDirectory(this.authInfo.getLogonToken());
            }
            if (string2 == null || string2.equals("")) {
                string2 = ConfigurationLoader.getPlatformConfiguration().getSetting("DefaultHomeDir");
            }
        } else {
            return false;
        }
        this.processInfo = this.createProcess(string, string3, string2, this.authInfo.getLogonToken());
        if (this.processInfo == null) {
            return false;
        }
        this.input = new WindowsProcessInputStream(this.processInfo.getStdoutReadHandle());
        this.output = new WindowsProcessOutputStream(this.processInfo.getStdinWriteHandle());
        this.error = new WindowsProcessInputStream(this.processInfo.getStderrReadHandle());
        return true;
    }

    private native int waitForProcessExitCode(int var1);

    private native boolean isProcessActive(int var1);

    private native WindowsProcessInfo createProcess(String var1, String var2, String var3, int var4);

    private native void killProcess(WindowsProcessInfo var1);

    private native String getNativeTerminalProvider();

    private native boolean resumeProcess(WindowsProcessInfo var1);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.loadLibrary("sshtools-daemon-win32");
        log = Logger.getLogger((Class)(class$com$sshtools$daemon$windows$WindowsProcess == null ? (class$com$sshtools$daemon$windows$WindowsProcess = WindowsProcess.class$("com.sshtools.daemon.windows.WindowsProcess")) : class$com$sshtools$daemon$windows$WindowsProcess));
    }
}

