/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.daemon;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

import org.apache.log4j.Logger;
import com.sshtools.j2ssh.SshServer;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingServer;
import com.sshtools.j2ssh.session.SessionChannelFactory;

public class SshDaemon {

  private static Logger log = Logger.getLogger(SshDaemon.class);

  public static void main(String[] args) {
    try {
      ConfigurationLoader.initialize(false);

      if (args.length > 0) {
        if (args[0].equals("-start")) {
          start();
        }
        else if (args[0].equals("-stop")) {
          stop();
        }
        else {
          System.out.println("Usage: SshDaemon [-start|-stop]");
        }
      }
      else {
        System.out.println("Usage: SshDaemon [-start|-stop]");
      }
    }
    catch (Exception e) {
      log.error("The server failed to process the "
                + ( (args.length > 0) ? args[0] : "") + " command", e);
    }
  }

  public static void start() throws IOException {
    // We need at least one host key
    SshServer server = new SshServer() {
      public void configureServices(ConnectionProtocol connection) throws
          IOException {

        connection.addChannelFactory(
            SessionChannelFactory.SESSION_CHANNEL,
            new SessionChannelFactory());

        if (ConfigurationLoader.getServerConfiguration().getAllowTcpForwarding()) {
          ForwardingServer forwarding = new ForwardingServer(connection);
        }

      }

    };
    server.startServer();
  }

  public static void stop() throws IOException {
    try {
      Socket socket = new Socket(InetAddress.getLocalHost(),
                                 ConfigurationLoader.getServerConfiguration().
                                 getCommandPort());
      socket.getOutputStream().write(0x3a);
      socket.close();
    }
    catch (IOException ioe) {
      ioe.printStackTrace();
    }
  }

}
