package com.sshtools.j2ssh.agent;


import java.net.*;
import java.io.*;
import com.sshtools.j2ssh.io.*;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import java.util.*;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.*;

import org.apache.log4j.Logger;

public class KeyStore {

   HashMap publickeys = new HashMap();
   HashMap privatekeys = new HashMap();
   HashMap constraints = new HashMap();
   Vector index = new Vector();

   Vector listeners = new Vector();
   String lockedPassword = null;

   private static Logger log = Logger.getLogger(KeyStore.class);


   public KeyStore() {
   }

   public Map getPublicKeys() {
     return (Map) publickeys.clone();
   }

   public int indexOf(SshPublicKey key) {
     return index.indexOf(key);
   }

   public SshPublicKey elementAt(int i) {
     return (SshPublicKey) index.elementAt(i);
   }

   public String getDescription(SshPublicKey key) {
     return (String) publickeys.get(key);
   }

   public KeyConstraints getKeyConstraints(SshPublicKey key) {
     return (KeyConstraints) constraints.get(key);
   }

   public int size() {
     return index.size();
   }

   public void addKeyStoreListener(KeyStoreListener listener) {
     listeners.add(listener);
   }

   public void removeKeyStoreListener(KeyStoreListener listener) {
     listeners.remove(listener);
   }

   public boolean addKey(SshPrivateKey prvkey,
                      SshPublicKey pubkey,
                      String description,
                      KeyConstraints cs) throws IOException {
     synchronized(publickeys) {
       if (!publickeys.containsKey(pubkey)) {
         publickeys.put(pubkey, description);
         privatekeys.put(pubkey, prvkey);
         constraints.put(pubkey, cs);
         index.add(pubkey);

         Iterator it = listeners.iterator();
         KeyStoreListener listener;
         while(it.hasNext()) {
           listener = (KeyStoreListener)it.next();
           listener.onAddKey(this);
         }
         return true;
       }
       else
         return false;
     }
   }

   public void deleteAllKeys() {
     synchronized(publickeys) {
       publickeys.clear();
       privatekeys.clear();
       constraints.clear();
       index.clear();
       Iterator it = listeners.iterator();
       KeyStoreListener listener;
       while (it.hasNext()) {
         listener = (KeyStoreListener) it.next();
         listener.onDeleteAllKeys(this);
       }
     }
   }

   public byte[] performHashAndSign(SshPublicKey pubkey, List forwardingNodes,
                                  byte[] data)
     throws KeyTimeoutException,
            InvalidSshKeyException
 {

     synchronized(publickeys) {
       if (privatekeys.containsKey(pubkey)) {

         SshPrivateKey key = (SshPrivateKey) privatekeys.get(pubkey);
         KeyConstraints cs = (KeyConstraints)
             constraints.get(pubkey);

         if (cs.canUse()) {
           if (!cs.hasTimedOut()) {

             cs.use();
             byte[] sig = key.generateSignature(data);
             Iterator it = listeners.iterator();
             KeyStoreListener listener;
             while (it.hasNext()) {
               listener = (KeyStoreListener) it.next();
               listener.onKeyOperation(this, "hash-and-sign");
             }
             return sig;

           }
           else
             throw new KeyTimeoutException();
         }
         else
           throw new KeyTimeoutException();

       }
       else
         throw new InvalidSshKeyException("The key does not exist");
     }

   }

   public boolean deleteKey(SshPublicKey pubkey, String description) throws IOException {

     synchronized(publickeys) {
       if (publickeys.containsKey(pubkey)) {
         String desc = (String) publickeys.get(pubkey);
         if (description.equals(desc)) {
           publickeys.remove(pubkey);
           privatekeys.remove(pubkey);
           constraints.remove(pubkey);
           index.remove(pubkey);
           Iterator it = listeners.iterator();
           KeyStoreListener listener;
           while (it.hasNext()) {
             listener = (KeyStoreListener) it.next();
             listener.onDeleteKey(this);
           }

           return true;
         }
       }

       return false;
     }
   }

   public boolean lock(String password) throws IOException {
     synchronized(publickeys) {
       if (lockedPassword == null) {
         lockedPassword = password;
         Iterator it = listeners.iterator();
         KeyStoreListener listener;
         while (it.hasNext()) {
           listener = (KeyStoreListener) it.next();
           listener.onLock(this);
         }
         return true;
       }
       else
         return false;
     }
   }

   public boolean unlock(String password) throws IOException {
     synchronized(publickeys) {
       if (lockedPassword != null) {
         if (password.equals(lockedPassword)) {
           lockedPassword = null;
           Iterator it = listeners.iterator();
           KeyStoreListener listener;
           while (it.hasNext()) {
             listener = (KeyStoreListener) it.next();
             listener.onUnlock(this);
           }
           return true;
         }
       }
        return false;
     }
   }


}