package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.*;
import java.util.*;

public class SshAgentAddKey extends SubsystemMessage {

  public static final int SSH_AGENT_ADD_KEY = 202;

  SshPrivateKey prvkey;
  SshPublicKey pubkey;
  String description;
  KeyConstraints constraints;

  public SshAgentAddKey() {
    super(SSH_AGENT_ADD_KEY);
  }

  public SshAgentAddKey(SshPrivateKey prvkey,
  SshPublicKey pubkey,
  String description,
  KeyConstraints constraints) {
  super(SSH_AGENT_ADD_KEY);

    this.prvkey = prvkey;
    this.pubkey = pubkey;
    this.description = description;
    this.constraints = constraints;

}

  public SshPrivateKey getPrivateKey() {
    return prvkey;
  }

  public SshPublicKey getPublicKey() {
    return pubkey;
  }

  public String getDescription() {
    return description;
  }

  public KeyConstraints getKeyConstraints() {
    return constraints;
  }

  public String getMessageName() {
    return "SSH_AGENT_ADD_KEY";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeBinaryString(prvkey.getEncoded());
      baw.writeBinaryString(pubkey.getEncoded());
      baw.writeString(description);
      baw.write(constraints.toByteArray());
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }

  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      prvkey = SshKeyPairFactory.decodePrivateKey(bar.readBinaryString());
      pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
      description = bar.readString();
      constraints = new KeyConstraints(bar);

    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}