package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import com.sshtools.j2ssh.transport.*;
import java.io.IOException;

public class SshAgentFailure extends SubsystemMessage {

  public static final int SSH_AGENT_FAILURE = 102;

  public static final int SSH_AGENT_ERROR_TIMEOUT = 1;
  public static final int SSH_AGENT_ERROR_KEY_NOT_FOUND = 2;
  public static final int SSH_AGENT_ERROR_DECRYPT_FAILED = 3;
  public static final int SSH_AGENT_ERROR_SIZE_ERROR = 4;
  public static final int SSH_AGENT_ERROR_KEY_NOT_SUITABLE = 5;
  public static final int SSH_AGENT_ERROR_DENIED = 6;
  public static final int SSH_AGENT_ERROR_FAILURE = 7;
  public static final int SSH_AGENT_ERROR_UNSUPPORTED_OP = 8;

  private int errorcode;

  public SshAgentFailure() {
    super(SSH_AGENT_FAILURE);
  }

  public SshAgentFailure(int errorcode) {
    super(SSH_AGENT_FAILURE);
    this.errorcode = errorcode;
  }

  public String getMessageName() {
    return "SSH_AGENT_FAILURE";
  }

  public int getErrorCode() {
    return errorcode;
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeInt(errorcode);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }
  }

  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      errorcode = (int)bar.readInt();
} catch(IOException ioe) {
  throw new InvalidMessageException(ioe.getMessage());
}

  }
}