package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.*;
import java.util.*;

public class SshAgentPrivateKeyOp extends SubsystemMessage {

  public static final int SSH_AGENT_PRIVATE_KEY_OP = 205;

  SshPublicKey pubkey;
  String operation;
  byte[] data;

  public SshAgentPrivateKeyOp() {
    super(SSH_AGENT_PRIVATE_KEY_OP);
  }

  public SshAgentPrivateKeyOp(SshPublicKey pubkey,
  String operation, byte[] data) {

  super(SSH_AGENT_PRIVATE_KEY_OP);

    this.pubkey = pubkey;
    this.operation = operation;
    this.data = data;

}

  public SshPublicKey getPublicKey() {
    return pubkey;
  }

  public String getOperation() {
    return operation;
  }

  public byte[] getOperationData() {
    return data;
  }

  public String getMessageName() {
    return "SSH_AGENT_PRIVATE_KEY_OP";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeString(operation);
      baw.writeBinaryString(pubkey.getEncoded());
      baw.write(data);

    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }

  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      operation = bar.readString();
      pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
      data = new byte[bar.available()];
      bar.read(data);
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}