package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.IOException;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;

public class SshAgentRandomData extends SubsystemMessage {

  public static final int SSH_AGENT_RANDOM_DATA = 106;

  private byte[] data;

  public SshAgentRandomData() {
    super(SSH_AGENT_RANDOM_DATA);
  }

  public SshAgentRandomData(byte[] data) {
    super(SSH_AGENT_RANDOM_DATA);
    this.data = data;
  }

  public byte[] getRandomData() {
    return data;
  }

  public String getMessageName() {
    return "SSH_AGENT_RANDOM_DATA";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeBinaryString(data);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      data = bar.readBinaryString();
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }

  }
}