package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public class SshAgentRequestVersion extends SubsystemMessage {

  public static final int SSH_AGENT_REQUEST_VERSION = 1;
  String version;

  public SshAgentRequestVersion() {
    super(SSH_AGENT_REQUEST_VERSION);
  }

  public SshAgentRequestVersion(String version) {
  super(SSH_AGENT_REQUEST_VERSION);
  this.version = version;
}

  public String getVersion() {
    return version;
  }


  public String getMessageName() {
    return "SSH_AGENT_REQUEST_VERSION";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeString(version);
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      version = bar.readString();
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}