/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import java.io.IOException;
import java.util.Map;

import org.apache.log4j.Logger;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.platform.PasswordChangeException;
import com.sshtools.j2ssh.transport.SshMessage;

public class KBIPasswordAuthenticationServer
    extends SshAuthenticationServer {
  private static Logger log = Logger.getLogger(KBIPasswordAuthenticationServer.class);

  public final String getMethodName() {
    return "keyboard-interactive";
  }

  public void setAuthenticatedTokens(Map tokens) {
  }

  public int authenticate(AuthenticationProtocolServer authentication,
                          SshMsgUserAuthRequest msg) throws IOException { //, Map nativeSettings)
    NativeAuthenticationProvider authImpl = NativeAuthenticationProvider
        .getInstance();

    if (authImpl == null) {
      log.error(
          "Cannot perfrom authentication witout native authentication provider");

      return AuthenticationProtocolState.FAILED;
    }

    authentication.registerMessage(SshMsgUserAuthInfoResponse.
                                   SSH_MSG_USERAUTH_INFO_RESPONSE,
                                   SshMsgUserAuthInfoResponse.class);

    SshMsgUserAuthInfoRequest info = new SshMsgUserAuthInfoRequest(
        "Password authentication",
        "", "");

    info.addPrompt(msg.getUsername() + "'s password", false);

    authentication.sendMessage(info);

    SshMessage response = authentication.readMessage();

    if (response instanceof SshMsgUserAuthInfoResponse) {
      String[] responses = ( (SshMsgUserAuthInfoResponse) response)
          .getResponses();

      if (responses.length == 1) {
        String password = responses[0];

        try {
          if (authImpl.logonUser(msg.getUsername(), password)) { //, nativeSettings)) {
            log.info(msg.getUsername()
                     + " has passed password authentication");

            return AuthenticationProtocolState.COMPLETE;
          }
          else {
            log.info(msg.getUsername()
                     + " has failed password authentication");

            return AuthenticationProtocolState.FAILED;
          }
        }
        catch (PasswordChangeException ex) {
          info = new SshMsgUserAuthInfoRequest("Password change required",
                                               "", "");
          info.addPrompt("New password", false);
          info.addPrompt("Confirm password", false);

          authentication.sendMessage(info);

          response = authentication.readMessage();

          if (response instanceof SshMsgUserAuthInfoResponse) {
            responses = ( (SshMsgUserAuthInfoResponse) response)
                .getResponses();

            if (responses.length == 2) {
              if (responses[0].equals(responses[1])) {
                if (authImpl.changePassword(msg.getUsername(),
                                            password, responses[0])) {
                  return AuthenticationProtocolState.COMPLETE;
                }
                else {
                  return AuthenticationProtocolState.FAILED;
                }
              }
              else {
                return AuthenticationProtocolState.FAILED;
              }
            }
            else {
              log.error("Client replied with an invalid message "
                        + response.getMessageName());

              return AuthenticationProtocolState.FAILED;
            }
          }
          else {
            log.error("Client replied with an invalid message "
                      + response.getMessageName());

            return AuthenticationProtocolState.FAILED;
          }
        }
      }
      else {
        log.error("Client responded with too many values!");

        return AuthenticationProtocolState.FAILED;
      }
    }
    else {
      log.error("Client replied with an invalid message "
                + response.getMessageName());

      return AuthenticationProtocolState.FAILED;
    }
  }
}
