/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;

public class SshMsgUserAuthPwdChangeReq
    extends SshMessage {
  public static final int SSH_MSG_USERAUTH_PWD_CHANGEREQ = 60;
  private String prompt;
  private String language;

  public SshMsgUserAuthPwdChangeReq() {
    super(SSH_MSG_USERAUTH_PWD_CHANGEREQ);
  }

  public SshMsgUserAuthPwdChangeReq(String prompt, String language) {
    super(SSH_MSG_USERAUTH_PWD_CHANGEREQ);
    this.prompt = prompt;
    this.language = language;
  }

  public String getPrompt() {
    return prompt;
  }

  public String getLanguage() {
    return language;
  }

  public String getMessageName() {
    return "SSH_MSG_USERAUTH_PWD_CHANGEREQ";
  }

  protected void constructByteArray(ByteArrayWriter baw) throws
      InvalidMessageException {
    try {
      baw.writeString(prompt);
      baw.writeString(language);
    }
    catch (Exception ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }

  protected void constructMessage(ByteArrayReader bar) throws
      InvalidMessageException {
    try {
      prompt = bar.readString();
      language = bar.readString();
    }
    catch (Exception ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}
