/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.*;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;

import java.util.*;


public class RemoteIdentificationFactory {
    private static Map remoteIdentifications = null;

    static {
        try {
            remoteIdentifications = ConfigurationLoader.getAutomationConfiguration()
                                                       .getRemoteIdentifications();
        } catch (ConfigurationException ex) {
        }
    }

    public static synchronized RemoteIdentification getInstance(String serverId)
        throws RemoteIdentificationException {
        if (remoteIdentifications == null) {
            throw new RemoteIdentificationException(
                "There are no remote identification rules!");
        }

        Iterator it = remoteIdentifications.entrySet().iterator();
        Map.Entry entry;
        RemoteIdentification rid;

        while (it.hasNext()) {
            entry = (Map.Entry) it.next();
            rid = (RemoteIdentification) entry.getValue();

            if (rid.testRules(serverId)) {
                return rid;
            }
        }

        throw new RemoteIdentificationException(
            "Failed to find a remote identification rule");
    }

    public static void main(String[] args) {
        try {
            RemoteIdentification rid;

            String serverId = "http://www.sshtools.com J2SSH 0.1.1 beta [CLIENT]";
            rid = getInstance(serverId);
            System.out.println("Remote Identification: "
                + rid.getName(serverId));
            serverId = "OpenSSH_3.4p1";
            rid = getInstance(serverId);
            System.out.println("Remote Identification: "
                + rid.getName(serverId));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
