/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;

import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;

import java.io.IOException;


public class SshMsgChannelExtendedData extends SshMessage {
    public final static int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    public final static int SSH_EXTENDED_DATA_STDERR = 1;
    private byte[] channelData;
    private int dataTypeCode;
    private long recipientChannel;

    public SshMsgChannelExtendedData(long recipientChannel, int dataTypeCode,
        byte[] channelData) {
        super(SSH_MSG_CHANNEL_EXTENDED_DATA);

        this.recipientChannel = recipientChannel;
        this.dataTypeCode = dataTypeCode;
        this.channelData = channelData;
    }

    public SshMsgChannelExtendedData() {
        super(SSH_MSG_CHANNEL_EXTENDED_DATA);
    }

    public byte[] getChannelData() {
        return channelData;
    }

    public int getDataTypeCode() {
        return dataTypeCode;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_EXTENDED_DATA";
    }

    public long getRecipientChannel() {
        return recipientChannel;
    }

    protected void constructByteArray(ByteArrayWriter baw)
        throws InvalidMessageException {
        try {
            baw.writeInt(recipientChannel);
            baw.writeInt(dataTypeCode);

            if (channelData != null) {
                baw.writeBinaryString(channelData);
            } else {
                baw.writeString("");
            }
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar)
        throws InvalidMessageException {
        try {
            recipientChannel = bar.readInt();
            dataTypeCode = (int) bar.readInt();

            if (bar.available() > 0) {
                channelData = bar.readBinaryString();
            }
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}
