/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;

import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;

import java.io.IOException;


public class SshMsgChannelOpenFailure extends SshMessage {
    protected final static int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    protected final static long SSH_OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
    protected final static long SSH_OPEN_CONNECT_FAILED = 2;
    protected final static long SSH_OPEN_UNKNOWN_CHANNEL_TYPE = 3;
    protected final static long SSH_OPEN_RESOURCE_SHORTAGE = 4;
    private String additional;
    private String languageTag;
    private long reasonCode;
    private long recipientChannel;

    public SshMsgChannelOpenFailure(long recipientChannel, long reasonCode,
        String additional, String languageTag) {
        super(SSH_MSG_CHANNEL_OPEN_FAILURE);
        this.recipientChannel = recipientChannel;
        this.reasonCode = reasonCode;
        this.additional = additional;
        this.languageTag = languageTag;
    }

    public SshMsgChannelOpenFailure() {
        super(SSH_MSG_CHANNEL_OPEN_FAILURE);
    }

    public String getAdditionalText() {
        return additional;
    }

    public String getLanguageTag() {
        return languageTag;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_OPEN_FAILURE";
    }

    public long getReasonCode() {
        return reasonCode;
    }

    public long getRecipientChannel() {
        return recipientChannel;
    }

    protected void constructByteArray(ByteArrayWriter baw)
        throws InvalidMessageException {
        try {
            baw.writeInt(recipientChannel);
            baw.writeInt(reasonCode);
            baw.writeString(additional);
            baw.writeString(languageTag);
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar)
        throws InvalidMessageException {
        try {
            recipientChannel = bar.readInt();
            reasonCode = bar.readInt();
            additional = bar.readString();
            languageTag = bar.readString();
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}
