/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.sshtools.j2ssh.forwarding;

public class XDisplay  {

    private String host;
    private int display, screen;
    private int portOffset;

    public XDisplay(String string) {
        this(string, 6000);
    }

    public XDisplay(String string, int portOffset) {
        setString(string);
        setPortOffset(portOffset);
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public int getPortOffset() {
        return portOffset;
    }

    public void setString(String string) {
        int idx = string.indexOf(':');
        if(idx == -1) {
            display = 0;
            host = string;
        }
        else {
            host = string.substring(0, idx);
            String s = string.substring(idx + 1);
            idx = s.indexOf(".");
            if(idx == -1) {
                screen = 0;
                try {
                    display = Integer.parseInt(s);
                }
                catch(NumberFormatException nfe) {
                    display = 0;
                }
            }
            else {
                try {
                    display = Integer.parseInt(s.substring(0, idx));
                }
                catch(NumberFormatException nfe) {
                    display = 0;
                }
                try {
                    screen = Integer.parseInt(s.substring(idx + 1));
                }
                catch(NumberFormatException nfe) {
                    screen = 0;
                }
            }
        }
    }

    public int getPort() {
        return getDisplay() < getPortOffset() ? getDisplay() + getPortOffset() : getDisplay();
    }

    public int getScreen() {
        return screen;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDisplay(int display) {
        this.display = display;
    }

    public void setScreen(int screen) {
        this.screen = screen;
    }


    public String getHost() {
        return host;
    }

    public int getDisplay() {
        return display;
    }

    public String toString() {
        return getHost() + ":" + getDisplay() + ( getScreen() == 0 ? "" : ( "." + getScreen() ) ) ;
    }
}
