/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.util.State;


public class IOStreamConnectorState extends State {
    public final static int BOF = 1;
    public final static int CONNECTED = 2;
    public final static int EOF = 3;
    public final static int CLOSED = 4;

    public IOStreamConnectorState() {
        super(BOF);
    }

    public boolean isValidState(int state) {
        return ((state == BOF) || (state == CONNECTED) || (state == EOF)
        || (state == CLOSED));
    }
}
