/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.io;

import java.io.Serializable;


public class UnsignedInteger32 extends Number implements Serializable {
    final static long serialVersionUID = 200;
    public final static long MAX_VALUE = 0xffffffffL;
    public final static long MIN_VALUE = 0;
    private Long value;

    public UnsignedInteger32(long a) {
        if ((a < MIN_VALUE) || (a > MAX_VALUE)) {
            throw new NumberFormatException();
        }

        value = new Long(a);
    }

    public UnsignedInteger32(String a) throws NumberFormatException {
        Long temp = new Long(a);
        long longValue = temp.longValue();

        if ((longValue < MIN_VALUE) || (longValue > MAX_VALUE)) {
            throw new NumberFormatException();
        }

        value = new Long(longValue);
    }

    public byte byteValue() {
        return value.byteValue();
    }

    public short shortValue() {
        return value.shortValue();
    }

    public int intValue() {
        return value.intValue();
    }

    public long longValue() {
        return value.longValue();
    }

    public float floatValue() {
        return value.floatValue();
    }

    public double doubleValue() {
        return value.doubleValue();
    }

    public String toString() {
        return value.toString();
    }

    public int hashCode() {
        return value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnsignedInteger32)) {
            return false;
        }

        return (((UnsignedInteger32) o).value.equals(this.value));
    }

    public static UnsignedInteger32 add(UnsignedInteger32 x, UnsignedInteger32 y) {
        return new UnsignedInteger32(x.longValue() + y.longValue());
    }

    public static UnsignedInteger32 add(UnsignedInteger32 x, int y) {
        return new UnsignedInteger32(x.longValue() + y);
    }
}
