/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.platform;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.PlatformConfiguration;

import org.apache.log4j.Logger;

import java.io.IOException;

import java.util.Map;


public abstract class NativeAuthenticationProvider {
    private static Logger log = Logger.getLogger(NativeAuthenticationProvider.class);
    private static NativeAuthenticationProvider instance;

    static {
        try {
            Class cls = ConfigurationLoader.getExtensionClass(ConfigurationLoader.getPlatformConfiguration()
                                                                                 .getNativeAuthenticationProvider());

            instance = (NativeAuthenticationProvider) cls.newInstance();
        } catch (Exception e) {
            log.error("Failed to load native authentication provider", e);
            instance = null;
        }
    }

    public abstract String getHomeDirectory(String username)
        throws IOException;

    public abstract boolean logonUser(String username, String password)
        throws PasswordChangeException, IOException;

    public abstract boolean logonUser(String username)
        throws IOException;

    public abstract void logoffUser() throws IOException;

    public abstract boolean changePassword(String username, String oldpassword,
        String newpassword);

    public static NativeAuthenticationProvider getInstance() {
        return instance;
    }
}
