/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.platform;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.PlatformConfiguration;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;

import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.sftp.StatusException;

import org.apache.log4j.Logger;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Map;


public abstract class NativeFileSystemProvider {
    private static Logger log = Logger.getLogger(NativeAuthenticationProvider.class);
    private static NativeFileSystemProvider instance;
    public static final int OPEN_READ = SftpSubsystemClient.OPEN_READ;
    public static final int OPEN_WRITE = SftpSubsystemClient.OPEN_WRITE;
    public static final int OPEN_APPEND = SftpSubsystemClient.OPEN_APPEND;
    public static final int OPEN_CREATE = SftpSubsystemClient.OPEN_CREATE;
    public static final int OPEN_TRUNCATE = SftpSubsystemClient.OPEN_TRUNCATE;
    public static final int OPEN_EXCLUSIVE = SftpSubsystemClient.OPEN_EXCLUSIVE;

    static {
        try {
            Class cls = ConfigurationLoader.getExtensionClass(ConfigurationLoader.getPlatformConfiguration()
                                                                                 .getNativeFileSystemProvider());

            instance = (NativeFileSystemProvider) cls.newInstance();
        } catch (Exception e) {
            log.error("Failed to load native file system provider", e);
            instance = null;
        }
    }

    public abstract boolean makeDirectory(String path)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public abstract FileAttributes getFileAttributes(String path)
        throws IOException, FileNotFoundException;

    public abstract FileAttributes getFileAttributes(byte[] handle)
        throws IOException, InvalidHandleException;

    public abstract byte[] openDirectory(String path)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public abstract File[] readDirectory(byte[] handle)
        throws InvalidHandleException, EOFException;

    public abstract byte[] openFile(String path, UnsignedInteger32 flags,
        FileAttributes attrs)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public abstract byte[] readFile(byte[] handle, UnsignedInteger64 offset,
        UnsignedInteger32 len)
        throws InvalidHandleException, EOFException, IOException;

    public abstract void writeFile(byte[] handle, UnsignedInteger64 offset,
        byte[] data, int off, int len)
        throws InvalidHandleException, IOException;

    public abstract void closeFile(byte[] handle)
        throws InvalidHandleException, IOException;

    public abstract void removeFile(String path)
        throws PermissionDeniedException, IOException, FileNotFoundException;

    public abstract void renameFile(String oldpath, String newpath)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public abstract void removeDirectory(String path)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public abstract void setFileAttributes(String path, FileAttributes attrs)
        throws PermissionDeniedException, IOException, FileNotFoundException;

    public abstract void setFileAttributes(byte[] handle, FileAttributes attrs)
        throws PermissionDeniedException, IOException, InvalidHandleException;

    public abstract File readSymbolicLink(String path)
        throws UnsupportedFileOperationException, FileNotFoundException,
            IOException, PermissionDeniedException;

    public abstract void createSymbolicLink(String link, String target)
        throws UnsupportedFileOperationException, FileNotFoundException,
            IOException, PermissionDeniedException;

    public abstract void verifyPermissions(String username, String path,
        String permissions)
        throws PermissionDeniedException, FileNotFoundException, IOException;

    public static NativeFileSystemProvider getInstance() {
        return instance;
    }
}
