/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.platform;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.PlatformConfiguration;

import com.sshtools.j2ssh.session.SessionDataProvider;

import com.sshtools.j2ssh.sftp.SftpSubsystemClient;

import org.apache.log4j.Logger;

import java.io.IOException;
import java.io.InputStream;

import java.util.Map;


public abstract class NativeProcessProvider implements SessionDataProvider {
    private static Logger log = Logger.getLogger(NativeProcessProvider.class);
    private static Class implementor;

    static {
        try {
            implementor = ConfigurationLoader.getExtensionClass(ConfigurationLoader.getPlatformConfiguration()
                                                                                   .getNativeProcessProvider());
        } catch (Exception e) {
            log.error("Failed to load native process provider", e);
            implementor = null;
        }
    }

    public static NativeProcessProvider newInstance() {
        try {
            return (NativeProcessProvider) implementor.newInstance();
        } catch (Exception e) {
            log.error("Failed to create native process provider instance", e);

            return null;
        }
    }

    public abstract InputStream getStderrInputStream();

    public abstract void kill();

    public abstract boolean stillActive();

    public abstract int waitForExitCode();

    public abstract String getDefaultTerminalProvider();

    //public abstract boolean start(String command, Map environment) throws IOException;
    public abstract boolean createProcess(String command, Map environment)
        throws IOException;

    public abstract void start() throws IOException;

    public abstract boolean supportsPseudoTerminal(String term);

    public abstract boolean allocatePseudoTerminal(String term, int cols,
        int rows, int width, int height, String modes);
}
