/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.terminal.*;

import java.io.*;


public class PseudoTerminalWrapper {
    private InputStream masterIn;
    private OutputStream masterOut;
    private InputStream slaveIn;
    private OutputStream slaveOut;
    private String term;
    private int cols;
    private int rows;
    private int width;
    private int height;
    private String modes;
    private TerminalIO terminal;
    private UserInput ui;

    public PseudoTerminalWrapper(String term, int cols, int rows, int width,
        int height, String modes) {
        this.term = term;
        this.cols = cols;
        this.rows = rows;
        this.height = height;
        this.width = width;
    }

    public void bindMasterInputStream(InputStream masterIn) {
        this.masterIn = masterIn;
    }

    public void bindMasterOutputStream(OutputStream masterOut) {
        this.masterOut = masterOut;
    }

    public void bindSlaveOutputStream(OutputStream slaveOut) {
        this.slaveOut = slaveOut;
    }

    public void bindSlaveInputStream(InputStream slaveIn) {
        this.slaveIn = slaveIn;
    }

    public void initialize() throws IOException {
        this.terminal = new TerminalIO(masterIn, masterOut, term, cols, rows);
        terminal.bindSlaveInputStream(slaveIn);
        terminal.bindSlaveOutputStream(slaveOut);
        ui = new UserInput(terminal, slaveOut);
    }

    public InputStream getMasterInputStream() {
        return terminal.getMasterInputStream();
    }
}
