/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;

import com.sshtools.j2ssh.subsystem.SubsystemMessage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class SshFxpName extends SubsystemMessage implements MessageRequestId {
    public static final int SSH_FXP_NAME = 104;
    private UnsignedInteger32 id;
    private SftpFile[] files;

    public SshFxpName(UnsignedInteger32 id, SftpFile[] files) {
        super(SSH_FXP_NAME);
        this.id = id;
        this.files = files;
    }

    public SshFxpName() {
        super(SSH_FXP_NAME);
    }

    public UnsignedInteger32 getId() {
        return id;
    }

    public SftpFile[] getFiles() {
        return files;
    }

    public void constructMessage(ByteArrayReader bar)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        id = bar.readUINT32();

        UnsignedInteger32 count = bar.readUINT32();
        files = new SftpFile[count.intValue()];

        String shortname;
        String longname;

        for (int i = 0; i < files.length; i++) {
            shortname = bar.readString();
            longname = bar.readString();
            files[i] = new SftpFile(shortname, new FileAttributes(bar));
        }
    }

    public String getMessageName() {
        return "SSH_FXP_NAME";
    }

    public void constructByteArray(ByteArrayWriter baw)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        baw.writeUINT32(id);
        baw.writeInt(files.length);

        SftpFile file;

        for (int i = 0; i < files.length; i++) {
            baw.writeString(files[i].getAbsolutePath());
            baw.writeString(files[i].getLongname());
            baw.write(files[i].getAttributes().toByteArray());
        }
    }
}
