/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.sftp;

public class StatusException extends Exception {
    public static final int STATUS_FX_OK = SshFxpStatus.STATUS_FX_OK;
    public static final int STATUS_FX_EOF = SshFxpStatus.STATUS_FX_EOF;
    public static final int STATUS_FX_NO_SUCH_FILE = SshFxpStatus.STATUS_FX_NO_SUCH_FILE;
    public static final int STATUS_FX_PERMISSION_DENIED = SshFxpStatus.STATUS_FX_PERMISSION_DENIED;
    public static final int STATUS_FX_FAILURE = SshFxpStatus.STATUS_FX_FAILURE;
    public static final int STATUS_FX_BAD_MESSAGE = SshFxpStatus.STATUS_FX_BAD_MESSAGE;
    public static final int STATUS_FX_NO_CONNECTION = SshFxpStatus.STATUS_FX_NO_CONNECTION;
    public static final int STATUS_FX_CONNECTION_LOST = SshFxpStatus.STATUS_FX_CONNECTION_LOST;
    public static final int STATUS_FX_OP_UNSUPPORTED = SshFxpStatus.STATUS_FX_OP_UNSUPPORTED;
    int errorcode;

    public StatusException(int errorcode, String msg) {
        super(msg);
        this.errorcode = errorcode;
    }

    public int getErrorCode() {
        return errorcode;
    }
}
