/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;

import java.io.IOException;


class SshMsgDisconnect extends SshMessage {
    protected final static int SSH_MSG_DISCONNECT = 1;
    public final static int HOST_NOT_ALLOWED = 1;
    public final static int PROTOCOL_ERROR = 2;
    public final static int KEY_EXCHANGE_FAILED = 3;
    public final static int RESERVED = 4;
    public final static int MAC_ERROR = 5;
    public final static int COMPRESSION_ERROR = 6;
    public final static int SERVICE_NOT_AVAILABLE = 7;
    public final static int PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public final static int HOST_KEY_NOT_VERIFIABLE = 9;
    public final static int CONNECTION_LOST = 10;
    public final static int BY_APPLICATION = 11;
    public final static int TOO_MANY_CONNECTIONS = 12;
    public final static int AUTH_CANCELLED_BY_USER = 13;
    public final static int NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public final static int ILLEGAL_USER_NAME = 15;

    // The readble version of the disconneciton reason
    private String desc;

    // The language tag
    private String langTag;

    // Holds the reason for disconnection
    private int reasonCode;

    public SshMsgDisconnect(int reasonCode, String desc, String langTag) {
        super(SSH_MSG_DISCONNECT);

        // Store the message values
        this.reasonCode = reasonCode;
        this.desc = desc;
        this.langTag = langTag;
    }

    public SshMsgDisconnect() {
        super(SSH_MSG_DISCONNECT);
    }

    public String getDescription() {
        return desc;
    }

    public String getLanguageTag() {
        return langTag;
    }

    public String getMessageName() {
        return "SSH_MSG_DISCONNECT";
    }

    public int getReasonCode() {
        return reasonCode;
    }

    protected void constructByteArray(ByteArrayWriter baw)
        throws InvalidMessageException {
        try {
            baw.writeInt(reasonCode);
            baw.writeString(desc);
            baw.writeString(langTag);
        } catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: "
                + ioe.getMessage());
        }
    }

    protected void constructMessage(ByteArrayReader bar)
        throws InvalidMessageException {
        try {
            // Save the values
            reasonCode = (int) bar.readInt();
            desc = bar.readString();
            langTag = bar.readString();
        } catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: "
                + ioe.getMessage());
        }
    }
}
