/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.util;

import java.io.Serializable;

public abstract class State implements Serializable {
    protected int state;

    public State(int initialState) {
        this.state = initialState;
    }

    public abstract boolean isValidState(int state);

    public synchronized void setValue(int state) throws InvalidStateException {
        if (!isValidState(state)) {
            throw new InvalidStateException("The state is invalid");
        }

        this.state = state;
        notifyAll();
    }

    public synchronized int getValue() {
        return state;
    }

    public synchronized void breakWaiting() {
        notifyAll();
    }

    public synchronized boolean waitForState(int state)
        throws InvalidStateException, InterruptedException {
        return waitForState(state, 0);
    }

    public synchronized boolean waitForState(int state, long timeout)
        throws InvalidStateException, InterruptedException {
        if (!isValidState(state)) {
            throw new InvalidStateException("The state is invalid");
        }

        if (timeout < 0) {
            timeout = 0;
        }

        while (this.state != state) {
         //   try {
                wait(timeout);

                if (timeout != 0) {
                    break;
                }
         //   } catch (InterruptedException e) {
        //        break;
        //    }
        }

        return this.state == state;
    }

    public synchronized int waitForStateUpdate() throws InterruptedException {
       // try {
            wait();
       // } catch (InterruptedException ie) {
      //  }

        return state;
    }

    /*public synchronized boolean waitForStateUpdate(long timeout) {

      int oldstate = state;

      if(timeout<0)
        timeout=0;

      try {
        wait(timeout);
      } catch(InterruptedException ie) {
      }

      return !(oldstate==state);
    }*/
}
