package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.connection.*;
import java.net.Socket;
import java.io.*;

import java.net.*;
import com.sshtools.j2ssh.io.ByteArrayWriter;


public class AgentForwardingChannel extends Channel {

  public static final String AGENT_FORWARDING_CHANNEL = "auth-agent";

  protected Socket socket = null;

  private boolean isForwarding;

  public AgentForwardingChannel(boolean isForwarding) {
    this.isForwarding = isForwarding;
  }

  public String getChannelType() {
    return AGENT_FORWARDING_CHANNEL;
  }

  public void bindSocket(Socket socket) throws IOException {

    this.socket = socket;

    if(state.getValue()==ChannelState.CHANNEL_OPEN) {
      bindInputStream(socket.getInputStream());
      bindOutputStream(socket.getOutputStream());
    }
  }

  protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws java.io.IOException {
    if(wantReply)
      connection.sendChannelRequestFailure(this);
  }

  protected int getMaximumPacketSize() {
    return 32678;
  }

  protected void onChannelClose() throws java.io.IOException {
  }

  public byte[] getChannelOpenData() {
    return null;
  }

  protected int getMinimumWindowSpace() {
    return 1024;
  }

  protected void onChannelOpen() throws com.sshtools.j2ssh.connection.InvalidChannelException {

    try {
      if (socket != null) {


        if(isForwarding) {
          // Were forwarding so insert the forwarding notice before any other data
          SshAgentForwardingNotice msg = new SshAgentForwardingNotice(
              InetAddress.getLocalHost().getHostName(),
              InetAddress.getLocalHost().getHostAddress(),
              socket.getPort());
          ByteArrayWriter baw = new ByteArrayWriter();
          baw.writeBinaryString(msg.toByteArray());
          connection.sendChannelData(this, baw.toByteArray());
        }

        // Now bind the socket to the channel
        bindInputStream(socket.getInputStream());
        bindOutputStream(socket.getOutputStream());
      }
    }
    catch (IOException ex) {
      throw new InvalidChannelException(ex.getMessage());
    }
  }

  protected int getMaximumWindowSpace() {
    return 32768;
  }

  public byte[] getChannelConfirmationData() {
    return null;
  }

}