package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.IOException;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public class SshAgentLock extends SubsystemMessage {

  public static final int SSH_AGENT_LOCK = 208;

  String password;

  public SshAgentLock() {
    super(SSH_AGENT_LOCK);
  }

  public SshAgentLock(String password) {
    super(SSH_AGENT_LOCK);
    this.password = password;
  }

  public String getPassword() {
    return password;
  }

  public String getMessageName() {
    return "SSH_AGENT_LOCK";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeString(password);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      password = bar.readString();
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }

  }
}