package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;

public class SshAgentOperationComplete extends SubsystemMessage {

  public static final int SSH_AGENT_OPERATION_COMPLETE = 105;

  private byte[] data;

  public SshAgentOperationComplete() {
    super(SSH_AGENT_OPERATION_COMPLETE);
  }

  public SshAgentOperationComplete(byte[] data) {
    super(SSH_AGENT_OPERATION_COMPLETE);
    this.data = data;
  }

  public byte[] getData() {
    return data;
  }

  public String getMessageName() {
    return "SSH_AGENT_OPERATION_COMPLETE";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeBinaryString(data);
    } catch(IOException ioe) {

    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      data = bar.readBinaryString();
    } catch(IOException ioe) {

    }

  }
}