package com.sshtools.j2ssh.agent;


import java.net.*;
import java.io.*;
import com.sshtools.j2ssh.io.*;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import java.util.*;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.*;

import org.apache.log4j.Logger;

public class SshAgentSocketListener {

   KeyStore keystore;
   ServerSocket server;
   int port;
   private static Logger log = Logger.getLogger(SshAgentSocketListener.class);


   public SshAgentSocketListener(String location, KeyStore keystore)
       throws AgentNotAvailableException {

     log.info("New SshAgent instance created");

     if(location==null)
             throw new AgentNotAvailableException();

     int idx = location.indexOf(":");

     if(idx==-1)
       throw new AgentNotAvailableException();

     String host = location.substring(0, idx);
     port = Integer.parseInt(location.substring(idx+1));

     this.keystore = keystore;

         try {
           server = new ServerSocket();
           server.bind(new InetSocketAddress(host, port));
         } catch(Exception e) {
         e.printStackTrace();
       }

   }

   public void start() throws IOException {


         Socket socket;
           while((socket = server.accept())!=null) {
             SshAgentConnection agentClient = new SshAgentConnection(
                 keystore,
                 socket.getInputStream(),
                 socket.getOutputStream());
           }


   }
   public int getPort() {
     return port;
   }

   public void stop() {
    try {
      server.close();
    }
    catch (IOException ex) {
    }
   }

   protected KeyStore getKeystore() {
     return keystore;
   }

   public static int configure() {
     return 49152 + (int) Math.round(((float)16383 * Math.random()));
   }

  public static void main(String args[]) {

    if(args.length > 0) {

      if(args[0].equals("-start")) {

          Thread thread = new Thread(new Runnable() {
            public void run() {
              try {
                SshAgentSocketListener agent = new SshAgentSocketListener(System.
                    getProperty("sshtools.agent"),
                    new KeyStore());
                agent.start();

              }
              catch (Exception ex) {
                ex.printStackTrace();
              }
            }
          });

          thread.start();


      }

      if(args[0].equals("-configure")) {
        System.out.println("SET SSHTOOLS_AGENT=localhost:"
                           + String.valueOf(configure()));
      }

    }

  }
}