package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public class SshAgentVersionResponse extends SubsystemMessage {

  public static final int SSH_AGENT_VERSION_RESPONSE = 103;
  UnsignedInteger32 version;

  public SshAgentVersionResponse() {
    super(SSH_AGENT_VERSION_RESPONSE);
  }

  public SshAgentVersionResponse(int version) {
  super(SSH_AGENT_VERSION_RESPONSE);
  this.version = new UnsignedInteger32(version);
}


  public int getVersion() {
    return version.intValue();
  }

  public String getMessageName() {
    return "SSH_AGENT_VERSION_RESPONSE";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeUINT32(version);
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      version = bar.readUINT32();
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}