/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.ant;

import com.sshtools.j2ssh.SshClient;

import com.sshtools.j2ssh.session.SessionChannelClient;

import com.sshtools.j2ssh.sftp.*;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import java.io.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;


public class Sftp {
    private String dest;
    private String get;
    private String put;
    private String mkdir;
    private String rmdir;
    private String delete;
    private String permissions;

    public Sftp() {
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDest() {
        return dest;
    }

    public void setGet(String get) {
        this.get = get;
    }

    public String getGet() {
        return get;
    }

    public void setPut(String put) {
        this.put = put;
    }

    public String getPut() {
        return put;
    }

    public void setMkdir(String mkdir) {
        this.mkdir = mkdir;
    }

    public String getMkdir() {
        return mkdir;
    }

    public void setRmdir(String rmdir) {
        this.rmdir = rmdir;
    }

    public String getRmdir() {
        return rmdir;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getPermissions() {
        return permissions;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String getDelete() {
        return delete;
    }

    protected void validate() throws org.apache.tools.ant.BuildException {
        if ((get != null) && (dest == null)) {
            throw new BuildException(
                "You must supply a destination for the get operation");
        }

        if ((put != null) && (dest == null)) {
            throw new BuildException(
                "You must supply a destination and permissions for the put operation");
        }

        if ((get != null) && (put != null)) {
            throw new BuildException(
                "You cannot specify a get and put together, use seperate tasks");
        }
    }
}
