/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.*;

import com.sshtools.j2ssh.transport.SshMessage;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

import javax.swing.*;
import javax.swing.text.*;


public class KBIAuthenticationClient extends SshAuthenticationClient {

    KBIRequestHandler handler;

    public Properties getPersistableProperties() {
        return new Properties();
    }

    public void setKBIRequestHandler(KBIRequestHandler handler) {
        this.handler = handler;
    }

    public void authenticate(AuthenticationProtocolClient authentication,
        String serviceToStart)
        throws com.sshtools.j2ssh.authentication.TerminatedStateException,
            java.io.IOException {
        if (handler == null) {
            throw new AuthenticationProtocolException(
                "A request handler must be set!");
        }

        authentication.registerMessage(SshMsgUserAuthInfoRequest.class,
            SshMsgUserAuthInfoRequest.SSH_MSG_USERAUTH_INFO_REQUEST);

        // Send the authentication request
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString("");
        baw.writeString("");

        SshMessage msg = new SshMsgUserAuthRequest(getUsername(),
                serviceToStart, getMethodName(), baw.toByteArray());

        authentication.sendMessage(msg);

        // Read a message
        while (true) {
            msg = authentication.readMessage(SshMsgUserAuthInfoRequest.SSH_MSG_USERAUTH_INFO_REQUEST);

            if (msg instanceof SshMsgUserAuthInfoRequest) {
                SshMsgUserAuthInfoRequest request = (SshMsgUserAuthInfoRequest) msg;
                KBIPrompt[] prompts = request.getPrompts();
                handler.showPrompts(request.getName(),
                    request.getInstruction(), prompts);

                // Now send the response message
                msg = new SshMsgUserAuthInfoResponse(prompts);
                authentication.sendMessage(msg);
            } else {
                throw new AuthenticationProtocolException(
                    "Unexpected authentication message " + msg.getMessageName());
            }
        }
    }

    public boolean canAuthenticate() {
        return true;
    }

    public String getMethodName() {
        return "keyboard-interactive";
    }

    public void setPersistableProperties(Properties properties) {
    }

   /* public boolean showAuthenticationDialog(Component parent)
        throws java.io.IOException {
        final Component myparent = parent;
        this.handler = new KBIRequestHandlerDialog();

        //        this.handler = new KBIRequestHandler() {
        //                    public void showPrompts(String name, String instructions,
        //                        KBIPrompt[] prompts) {
        //                        if (prompts != null) {
        //                            for (int i = 0; i < prompts.length; i++) {
        //                                // We can echo the response back to the client
        //                                prompts[i].setResponse((JOptionPane
        //                                    .showInputDialog(myparent,
        //                                        prompts[i].getPrompt(), name,
        //                                        JOptionPane.QUESTION_MESSAGE)));
        //                            }
        //                        }
        //                    }
        //                };
        return true;
    }*/

}
