/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import com.sshtools.j2ssh.io.ByteArrayWriter;
public class PasswordAuthenticationClient
    extends SshAuthenticationClient {
  private static Logger log = Logger.getLogger(PasswordAuthenticationClient.class);
  private PasswordChangePrompt changePrompt = null;
  protected String password = null;
  public final String getMethodName() {
    return "password";
  }
  public final void setPassword(String password) {
    this.password = password;
  }
  public void setPasswordChangePrompt(PasswordChangePrompt changePrompt) {
    this.changePrompt = changePrompt;
  }
  /*public boolean showAuthenticationDialog(Component parent)
      throws AuthenticationProtocolException {
      if (password != null) {
          return true;
      }
      // Create the password authentication dialog
      Window w = (Window) SwingUtilities.getAncestorOfClass(Window.class,
              parent);
      PasswordAuthenticationDialog dialog = null;
      if (w instanceof Frame) {
          dialog = new PasswordAuthenticationDialog((Frame) w);
      } else if (w instanceof Dialog) {
          dialog = new PasswordAuthenticationDialog((Dialog) w);
      } else {
          dialog = new PasswordAuthenticationDialog();
      }
      // Show the dialog
      if (dialog.showPromptForPassword(getUsername())) {
          setUsername(dialog.getUsername());
          setPassword(dialog.getPassword());
          return true;
      }
      return false;
       }*/
  /*public void setAuthenticatedTokens(Map tokens) {
       }*/
  public void authenticate(AuthenticationProtocolClient authentication,
                           String serviceToStart) throws IOException,
      TerminatedStateException {
    if ( (getUsername() == null) || (password == null)) {
      throw new AuthenticationProtocolException(
          "Username and password cannot be null!");
    }
    // Send a password authentication request
    ByteArrayWriter baw = new ByteArrayWriter();
    baw.write(0);
    baw.writeString(password);
    SshMsgUserAuthRequest msg = new SshMsgUserAuthRequest(getUsername(),
        serviceToStart, "password", baw.toByteArray());
    authentication.sendMessage(msg);
    SshMsgUserAuthPwdChangeReq pwd = (SshMsgUserAuthPwdChangeReq)
        authentication
        .readMessage(SshMsgUserAuthPwdChangeReq.SSH_MSG_USERAUTH_PWD_CHANGEREQ);
    if (changePrompt != null) {
      String newpassword = changePrompt.changePassword(pwd.getPrompt());
      if (newpassword != null) {
          log.debug("Setting new password");
        baw = new ByteArrayWriter();
        baw.write(1);
        baw.writeString(password);
        baw.writeString(newpassword);
        msg = new SshMsgUserAuthRequest(getUsername(), serviceToStart,
                                        "password", baw.toByteArray());
        authentication.sendMessage(msg);
      }
      else {
        throw new TerminatedStateException(AuthenticationProtocolState.FAILED);
      }
    }
    else {
      throw new TerminatedStateException(AuthenticationProtocolState.FAILED);
    }
  }
  public Properties getPersistableProperties() {
    Properties properties = new Properties();
    if (getUsername() != null) {
      properties.setProperty("Username", getUsername());
    }
    return properties;
  }
  public void setPersistableProperties(Properties properties) {
    setUsername(properties.getProperty("Username"));
    if (properties.getProperty("Password") != null) {
      setPassword(properties.getProperty("Password"));
    }
  }
  public boolean canAuthenticate() {
    return ( (getUsername() != null) && (password != null));
  }
}
