/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import java.io.IOException;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;

public class SshMsgUserAuthRequest
    extends SshMessage {
  public final static int SSH_MSG_USERAUTH_REQUEST = 50;
  private String methodName;
  private String serviceName;
  private String username;
  private byte[] requestData;

  public SshMsgUserAuthRequest() {
    super(SSH_MSG_USERAUTH_REQUEST);
  }

  public SshMsgUserAuthRequest(String username, String serviceName,
                               String methodName, byte[] requestData) {
    super(SSH_MSG_USERAUTH_REQUEST);

    this.username = username;
    this.serviceName = serviceName;
    this.methodName = methodName;
    this.requestData = requestData;
  }

  public String getMessageName() {
    return "SSH_MSG_USERAUTH_REQUEST";
  }

  public String getMethodName() {
    return methodName;
  }

  public byte[] getRequestData() {
    return requestData;
  }

  public String getServiceName() {
    return serviceName;
  }

  public String getUsername() {
    return username;
  }

  protected void constructByteArray(ByteArrayWriter baw) throws
      InvalidMessageException {
    try {
      baw.writeString(username);
      baw.writeString(serviceName);
      baw.writeString(methodName);

      if (requestData != null) {
        baw.write(requestData);
      }
    }
    catch (IOException ioe) {
      throw new InvalidMessageException("Invalid message data");
    }
  }

  protected void constructMessage(ByteArrayReader bar) throws
      InvalidMessageException {
    try {
      username = bar.readString();
      serviceName = bar.readString();
      methodName = bar.readString();

      if (bar.available() > 0) {
        requestData = new byte[bar.available()];
        bar.read(requestData);
      }
    }
    catch (IOException ioe) {
      throw new InvalidMessageException("Invalid message data");
    }
  }
}
