/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;

import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;

import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;

import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;

import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;

import org.apache.log4j.Logger;

import java.math.BigInteger;

import java.util.ArrayList;
import java.util.List;


public class SshConnectionProperties {
    private static Logger log = Logger.getLogger(SshConnectionProperties.class);
    protected String host;
    protected String prefDecryption = SshCipherFactory.getDefaultCipher();
    protected String prefEncryption = SshCipherFactory.getDefaultCipher();
    protected String prefKex = SshKeyExchangeFactory.getDefaultKeyExchange();
    protected String prefPK = SshKeyPairFactory.getDefaultPublicKey();
    protected String prefRecvComp = SshCompressionFactory.getDefaultCompression();
    protected String prefRecvMac = SshHmacFactory.getDefaultHmac();
    protected String prefSendComp = SshCompressionFactory.getDefaultCompression();
    protected String prefSendMac = SshHmacFactory.getDefaultHmac();
    protected String username;
    protected int port = 22;

    public SshConnectionProperties() {
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return port;
    }

    public void setPrefCSComp(String pref) {
        prefSendComp = pref;
    }

    public String getPrefCSComp() {
        return prefSendComp;
    }

    public void setPrefCSEncryption(String pref) {
        prefEncryption = pref;
    }

    public String getPrefCSEncryption() {
        return prefEncryption;
    }

    public void setPrefCSMac(String pref) {
        prefSendMac = pref;
    }

    public String getPrefCSMac() {
        return prefSendMac;
    }

    public void setPrefKex(String pref) {
        prefKex = pref;
    }

    public String getPrefKex() {
        return prefKex;
    }

    public void setPrefPublicKey(String pref) {
        prefPK = pref;
    }

    public String getPrefPublicKey() {
        return prefPK;
    }

    public void setPrefSCComp(String pref) {
        prefRecvComp = pref;
    }

    public String getPrefSCComp() {
        return prefRecvComp;
    }

    public void setPrefSCEncryption(String pref) {
        prefDecryption = pref;
    }

    public String getPrefSCEncryption() {
        return prefDecryption;
    }

    public void setPrefSCMac(String pref) {
        prefRecvMac = pref;
    }

    public String getPrefSCMac() {
        return prefRecvMac;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return username;
    }
}
