/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;

import java.io.IOException;

import java.util.HashMap;
import java.util.Map;


public class AuthorizedKeys {
    private HashMap keys = new HashMap();

    public Map getAuthorizedKeys() {
        return keys;
    }

    public void addKey(String username, SshPublicKey key) {
        if (!containsKey(key)) {
            keys.put(username, key);
        }
    }

    public void removeKey(String username) {
        keys.remove(username);
    }

    public boolean containsKey(SshPublicKey key) {
        return keys.containsValue(key);
    }

    public static AuthorizedKeys parse(byte[] formatted, String serverId,
        AuthorizedKeysFileLoader loader)
        throws RemoteIdentificationException, IOException, 
            InvalidSshKeyException {
        AuthorizedKeysFormat format = RemoteIdentificationFactory.getInstance(serverId)
                                                                 .getAuthorizedKeysFormat();

        if (format.requiresKeyFiles()) {
            return format.unformat(formatted, loader);
        } else {
            return format.unformat(formatted);
        }
    }

    public static byte[] create(AuthorizedKeys keys, String serverId,
        AuthorizedKeysFileSaver saver)
        throws RemoteIdentificationException, IOException, 
            InvalidSshKeyException {
        AuthorizedKeysFormat format = RemoteIdentificationFactory.getInstance(serverId)
                                                                 .getAuthorizedKeysFormat();

        if (format.requiresKeyFiles()) {
            return format.format(keys, saver);
        } else {
            return format.format(keys);
        }
    }
}
