/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.Iterator;
import java.util.Map;


public class OpenSSHAuthorizedKeysFormat implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys keys, AuthorizedKeysFileSaver saver)
        throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException(
            "The OpenSSH authorized key file does not support additional key files!");
    }

    public AuthorizedKeys unformat(byte[] formatted,
        AuthorizedKeysFileLoader loader)
        throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException(
            "The OpenSSH authorized key file does not support additional key files!");
    }

    public byte[] format(AuthorizedKeys keys)
        throws IOException, InvalidSshKeyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SshPublicKeyFile pubfile;
        OpenSSHPublicKeyFormat openssh = new OpenSSHPublicKeyFormat();
        Map.Entry entry;

        for (Iterator it = keys.getAuthorizedKeys().entrySet().iterator();
                (it != null) && it.hasNext();) {
            entry = (Map.Entry) it.next();
            openssh.setComment((String) entry.getKey());
            pubfile = SshPublicKeyFile.create((SshPublicKey) entry.getValue(),
                    openssh);
            out.write(pubfile.toString().getBytes());
            out.write('\n');
        }

        return out.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] formatted)
        throws IOException, InvalidSshKeyException {
        AuthorizedKeys keys = new AuthorizedKeys();
        BufferedReader reader = new BufferedReader(new InputStreamReader(
                    new ByteArrayInputStream(formatted)));
        String line;
        SshPublicKeyFile pubfile;

        while ((line = reader.readLine()) != null) {
            pubfile = SshPublicKeyFile.parse(line.getBytes());
            keys.addKey(pubfile.getComment(), pubfile.toPublicKey());
        }

        return keys;
    }

    public boolean requiresKeyFiles() {
        return false;
    }
}
