/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.Authorization;

import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;

import org.xml.sax.*;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.*;


public class SshtoolsAuthorizedKeysFormat implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys keys) {
        throw new java.lang.UnsupportedOperationException(
            "SSHTools authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] formatted) {
        throw new java.lang.UnsupportedOperationException(
            "SSHTools authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys keys, AuthorizedKeysFileSaver saver)
        throws IOException, InvalidSshKeyException {
        Authorization authorization = new Authorization();
        SshPublicKeyFile pubfile;
        SECSHPublicKeyFormat secsh = new SECSHPublicKeyFormat();
        Map.Entry entry;

        for (Iterator it = keys.getAuthorizedKeys().entrySet().iterator();
                (it != null) && it.hasNext();) {
            entry = (Map.Entry) it.next();

            // Write out the public key file
            String username = (String) entry.getKey();
            String filename = username + ".pub";
            secsh.setComment(username);
            pubfile = SshPublicKeyFile.create((SshPublicKey) entry.getValue(),
                    secsh);
            saver.saveFile(filename, pubfile.toString().getBytes());

            // Write out the key entry
            authorization.addKey(filename);
        }

        return authorization.toString().getBytes();
    }

    public AuthorizedKeys unformat(byte[] formatted,
        AuthorizedKeysFileLoader loader)
        throws IOException, InvalidSshKeyException {
        try {
            AuthorizedKeys keys = new AuthorizedKeys();
            Authorization authorization = new Authorization(new ByteArrayInputStream(
                        formatted));
            List keyfiles = authorization.getAuthorizedKeys();
            Iterator it = keyfiles.iterator();
            String filename;
            SshPublicKeyFile pubfile;
            String username;

            while (it.hasNext()) {
                filename = (String) it.next();
                pubfile = SshPublicKeyFile.parse(loader.loadFile(filename));
                username = filename.substring(0, filename.length() - 4);
                keys.addKey(username, pubfile.toPublicKey());
            }

            return keys;
        } catch (ParserConfigurationException ex) {
            throw new IOException("Failed to read authorization file: "
                + ex.getMessage());
        } catch (SAXException ex) {
            throw new IOException("Failed to read authorization file: "
                + ex.getMessage());
        }
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}
