/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;

import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;

import java.io.IOException;


public class SshMsgGlobalRequest extends SshMessage {
    protected final static int SSH_MSG_GLOBAL_REQUEST = 80;
    private String requestName;
    private byte[] requestData;
    private boolean wantReply;

    public SshMsgGlobalRequest(String requestName, boolean wantReply,
        byte[] requestData) {
        super(SSH_MSG_GLOBAL_REQUEST);

        this.requestName = requestName;
        this.wantReply = wantReply;
        this.requestData = requestData;
    }

    public SshMsgGlobalRequest() {
        super(SSH_MSG_GLOBAL_REQUEST);
    }

    public String getMessageName() {
        return "SSH_MSG_GLOBAL_REQUEST";
    }

    public byte[] getRequestData() {
        return requestData;
    }

    public String getRequestName() {
        return requestName;
    }

    public boolean getWantReply() {
        return wantReply;
    }

    protected void constructByteArray(ByteArrayWriter baw)
        throws InvalidMessageException {
        try {
            baw.writeString(requestName);
            baw.write((wantReply ? 1 : 0));

            if (requestData != null) {
                baw.write(requestData);
            }
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar)
        throws InvalidMessageException {
        try {
            requestName = bar.readString();
            wantReply = ((bar.read() == 0) ? false : true);

            if (bar.available() > 0) {
                requestData = new byte[bar.available()];
                bar.read(requestData);
            }
        } catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}
