/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;

import com.sshtools.j2ssh.subsystem.*;


public class SshFxpMkdir extends SubsystemMessage implements MessageRequestId {
    public static final int SSH_FXP_MKDIR = 14;
    private UnsignedInteger32 id;
    private String path;
    private FileAttributes attrs;

    public SshFxpMkdir() {
        super(SSH_FXP_MKDIR);
    }

    public SshFxpMkdir(UnsignedInteger32 id, String path, FileAttributes attrs) {
        super(SSH_FXP_MKDIR);
        this.id = id;
        this.path = path;
        this.attrs = attrs;
    }

    public UnsignedInteger32 getId() {
        return id;
    }

    public String getPath() {
        return path;
    }

    public FileAttributes getAttributes() {
        return attrs;
    }

    public void constructMessage(ByteArrayReader bar)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        id = bar.readUINT32();
        path = bar.readString();
        attrs = new FileAttributes(bar);
    }

    public String getMessageName() {
        return "SSH_FXP_MKDIR";
    }

    public void constructByteArray(ByteArrayWriter baw)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        baw.writeUINT32(id);
        baw.writeString(path);
        baw.write(attrs.toByteArray());
    }
}
