/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;

import com.sshtools.j2ssh.subsystem.*;


public class SshFxpRemove extends SubsystemMessage implements MessageRequestId {
    public static final int SSH_FXP_REMOVE = 13;
    private UnsignedInteger32 id;
    private String filename;

    public SshFxpRemove() {
        super(SSH_FXP_REMOVE);
    }

    public SshFxpRemove(UnsignedInteger32 id, String filename) {
        super(SSH_FXP_REMOVE);
        this.id = id;
        this.filename = filename;
    }

    public UnsignedInteger32 getId() {
        return id;
    }

    public String getFilename() {
        return filename;
    }

    public void constructMessage(ByteArrayReader bar)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        id = bar.readUINT32();
        filename = bar.readString();
    }

    public String getMessageName() {
        return "SSH_FXP_REMOVE";
    }

    public void constructByteArray(ByteArrayWriter baw)
        throws java.io.IOException, 
            com.sshtools.j2ssh.transport.InvalidMessageException {
        baw.writeUINT32(id);
        baw.writeString(filename);
    }
}
