/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.transport.AlgorithmOperationException;


public abstract class SshCipher {
    public static final int ENCRYPT_MODE = 0;
    public static final int DECRYPT_MODE = 1;

    public abstract int getBlockSize();

    public abstract void init(int mode, byte[] iv, byte[] keydata)
        throws AlgorithmOperationException;

    public byte[] transform(byte[] data) throws AlgorithmOperationException {
        return transform(data, 0, data.length);
    }

    public abstract byte[] transform(byte[] data, int offset, int len)
        throws AlgorithmOperationException;
}
