/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.*;

import org.apache.log4j.Logger;

import java.util.*;


public class SshPrivateKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes = new HashMap();
    private static Logger log = Logger.getLogger(SshPrivateKeyFormatFactory.class);
    private static Vector types = new Vector();

    static {
        List formats = new ArrayList();
        formats.add(SshtoolsPrivateKeyFormat.class.getName());
        defaultFormat = "SSHTools-PrivateKey-Base64Encoded";

        try {
            SshAPIConfiguration config = ConfigurationLoader
                .getAPIConfiguration();
            defaultFormat = config.getDefaultPrivateKeyFormat();
            formats.addAll(config.getPrivateKeyFormats());
        } catch (ConfigurationException ex) {
        }

        log.debug("Default private key format will be " + defaultFormat);

        Iterator it = formats.iterator();
        String classname;
        SshPrivateKeyFormat f;

        while (it.hasNext()) {
            classname = (String) it.next();

            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                f = (SshPrivateKeyFormat) cls.newInstance();
                log.debug("Installing " + f.getFormatType()
                    + " private key format");
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            } catch (Exception iae) {
                log.warn("Private key format implemented by " + classname
                    + " will not be available", iae);
            }
        }
    }

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPrivateKeyFormat newInstance(String type)
        throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPrivateKeyFormat) ((Class) formatTypes.get(type))
                .newInstance();
            } else {
                throw new InvalidSshKeyException("The format type " + type
                    + " is not supported");
            }
        } catch (IllegalAccessException iae) {
            throw new InvalidSshKeyException(
                "Illegal access to class implementation of " + type);
        } catch (InstantiationException ie) {
            throw new InvalidSshKeyException(
                "Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }
}
