/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.io.ByteArrayWriter;

import java.io.IOException;

import java.math.BigInteger;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;


public class Hash {
    private MessageDigest hash;

    public Hash(String algorithm) throws NoSuchAlgorithmException {
        hash = MessageDigest.getInstance(algorithm);
    }

    public void putBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();

        putInt(data.length);
        hash.update(data);
    }

    public void putByte(byte b) {
        hash.update(b);
    }

    public void putBytes(byte[] data) {
        hash.update(data);
    }

    public void putInt(int i) {
        ByteArrayWriter baw = new ByteArrayWriter();

        try {
            baw.writeInt(i);
        } catch (IOException ioe) {
        }

        hash.update(baw.toByteArray());
    }

    public void putString(String str) {
        putInt(str.length());

        hash.update(str.getBytes());
    }

    public void reset() {
        hash.reset();
    }

    public static byte[] simple(byte[] data, String algorithm)
        throws NoSuchAlgorithmException {
        MessageDigest simp = MessageDigest.getInstance(algorithm);

        simp.update(data);

        return simp.digest();
    }

    public byte[] doFinal() {
        return hash.digest();
    }
}
