/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.SshThread;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;


public class MultipleStateMonitor {
    private List monitors = new Vector();
    private List states = new Vector();
    private State changed = null;

    public MultipleStateMonitor() {
    }

    public void addState(State state) {
        states.add(state);
    }

    public synchronized void breakWaiting() {
        notifyAll();
    }

    public synchronized State monitor() {
        monitors.clear();

        Iterator it = states.iterator();

        while (it.hasNext()) {
            monitors.add(new StateMonitor((State) it.next(), this));
        }

        try {
            wait();
        } catch (InterruptedException e) {
        }

        return changed;
    }

    public synchronized void updateState() {
        notifyAll();
    }

    class StateMonitor implements Runnable {
        private MultipleStateMonitor monitor;
        private State state;
        private Thread thread;
        private boolean active = false;

        public StateMonitor(State state, MultipleStateMonitor monitor) {
            this.state = state;
            this.monitor = monitor;
            thread = new SshThread(this, "Multiple state monitor", true);
            thread.start();
        }

        public void close() {
            active = false;
            monitor.breakWaiting();
        }

        public void run() {
            active = true;

            while (active) {
                try {
                  state.waitForStateUpdate();
                }
                catch (InterruptedException ex) {
                }

                if (active) {
                    monitor.updateState();
                }
            }
        }
    }
}
