/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.util.InvalidStateException;
import java.io.Serializable;

public abstract class State
implements Serializable {
    protected int state;

    public State(int n) {
        this.state = n;
    }

    public abstract boolean isValidState(int var1);

    public synchronized void setValue(int n) throws InvalidStateException {
        if (!this.isValidState(n)) {
            throw new InvalidStateException("The state is invalid");
        }
        this.state = n;
        this.notifyAll();
    }

    public synchronized int getValue() {
        return this.state;
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized boolean waitForState(int n) throws InvalidStateException, InterruptedException {
        return this.waitForState(n, 0L);
    }

    public synchronized boolean waitForState(int n, long l) throws InvalidStateException, InterruptedException {
        if (!this.isValidState(n)) {
            throw new InvalidStateException("The state is invalid");
        }
        if (l < 0L) {
            l = 0L;
        }
        while (this.state != n) {
            this.wait(l);
            if (l != 0L) break;
        }
        return this.state == n;
    }

    public synchronized int waitForStateUpdate() throws InterruptedException {
        this.wait();
        return this.state;
    }
}

