/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;

public class SftpFile
implements Comparable {
    private String filename;
    private byte[] handle;
    private FileAttributes attrs;
    private SftpSubsystemClient sftp;
    private String absolutePath;

    public SftpFile(String string, FileAttributes fileAttributes) {
        this.absolutePath = string;
        int n = string.lastIndexOf("/");
        this.filename = n > -1 ? string.substring(n + 1) : string;
        this.attrs = fileAttributes;
    }

    public SftpFile(String string) {
        this(string, new FileAttributes());
    }

    public void delete() throws IOException {
        if (this.sftp == null) {
            throw new IOException("Instance not connected to SFTP subsystem");
        }
        if (this.isDirectory()) {
            this.sftp.removeDirectory(this.getAbsolutePath());
        } else {
            this.sftp.removeFile(this.getAbsolutePath());
        }
    }

    public void rename(String string) throws IOException {
        if (this.sftp == null) {
            throw new IOException("Instance not connected to SFTP subsystem");
        }
        this.sftp.renameFile(this.getAbsolutePath() + this.filename, string);
    }

    public boolean canWrite() {
        return (this.getAttributes().getPermissions().longValue() & 0x80L) == 128L;
    }

    public boolean canRead() {
        return (this.getAttributes().getPermissions().longValue() & 0x100L) == 256L;
    }

    public boolean isOpen() {
        if (this.sftp == null) {
            return false;
        }
        return this.sftp.isValidHandle(this.handle);
    }

    protected void setHandle(byte[] byArray) {
        this.handle = byArray;
    }

    protected byte[] getHandle() {
        return this.handle;
    }

    protected void setSFTPSubsystem(SftpSubsystemClient sftpSubsystemClient) {
        this.sftp = sftpSubsystemClient;
    }

    protected SftpSubsystemClient getSFTPSubsystem() {
        return this.sftp;
    }

    public String getFilename() {
        return this.filename;
    }

    private String pad(int n) {
        String string = "";
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                string = string + " ";
                ++n2;
            }
        }
        return string;
    }

    public String getLongname() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pad(10 - this.getAttributes().getPermissionsString().length()) + this.getAttributes().getPermissionsString());
        stringBuffer.append("   1 ");
        stringBuffer.append(this.getAttributes().getUID().toString() + this.pad(8 - this.getAttributes().getUID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getAttributes().getGID().toString() + this.pad(8 - this.getAttributes().getGID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.pad(8 - this.getAttributes().getSize().toString().length()) + this.getAttributes().getSize().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.pad(12 - this.getAttributes().getModTimeString().length()) + this.getAttributes().getModTimeString());
        stringBuffer.append(" ");
        stringBuffer.append(this.filename);
        return stringBuffer.toString();
    }

    public FileAttributes getAttributes() {
        try {
            if (this.attrs == null) {
                this.attrs = this.sftp.getAttributes(this);
            }
        }
        catch (IOException iOException) {
            this.attrs = new FileAttributes();
        }
        return this.attrs;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void close() throws IOException {
        this.sftp.closeFile(this);
    }

    public boolean isDirectory() {
        return (this.getAttributes().getPermissions().intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        return (this.getAttributes().getPermissions().intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        return (this.getAttributes().getPermissions().intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        return (this.getAttributes().getPermissions().intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        return (this.getAttributes().getPermissions().intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        return (this.getAttributes().getPermissions().intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        return (this.getAttributes().getPermissions().intValue() & 0xC000) == 49152;
    }

    public int compareTo(Object object) {
        return this.getFilename().compareTo(((SftpFile)object).getFilename());
    }
}

