/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.ColorComboBox;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SshTermTerminalTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final String DEFAULT = "<Default>";
    static final String TERM_ICON = "/com/sshtools/sshterm/largeterminal.png";
    protected SshToolsConnectionProfile profile;
    protected JComboBox jComboTerm = new JComboBox();
    protected JComboBox jComboResizeStrategy = new JComboBox<String>(new String[]{"None", "Font", "Screen"});
    protected JComboBox jComboEOL = new JComboBox<String>(new String[]{"Default", "CR+LF", "CR"});
    protected JComboBox jComboScreenSize = new JComboBox<String>(new String[]{"640x480", "800x600", "1024x768"});
    protected JComboBox fontSize = new JComboBox<String>(new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "22", "24", "26", "28", "32", "36", "40", "48", "56", "64", "8", "72"});
    protected JCheckBox antialias = new JCheckBox("Antialias (may be slow)");
    protected ColorComboBox backgroundColor = new ColorComboBox();
    protected ColorComboBox foregroundColor = new ColorComboBox();
    protected JLabel fontLabel;
    protected JCheckBox colorPrinting = new JCheckBox("Color printing");

    public SshTermTerminalTab() {
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Colors"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Background Color"), gridBagConstraints, -1);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, this.backgroundColor, gridBagConstraints, 0);
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Foreground Color"), gridBagConstraints, -1);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, this.foregroundColor, gridBagConstraints, 0);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        UIUtil.jGridBagAdd(jPanel, this.colorPrinting, gridBagConstraints, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("General"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Terminal type"), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel2, this.jComboTerm, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Resize strategy"), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel2, this.jComboResizeStrategy, gridBagConstraints2, 0);
        this.jComboResizeStrategy.addActionListener(this);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 26, 2, 2);
        this.fontLabel = new JLabel("Default font size");
        UIUtil.jGridBagAdd(jPanel2, this.fontLabel, gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = insets;
        this.fontSize.setEditable(true);
        UIUtil.jGridBagAdd(jPanel2, this.fontSize, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("EOL Type"), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel2, this.jComboEOL, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Screen Size"), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel2, this.jComboScreenSize, gridBagConstraints2, 0);
        this.antialias.setMnemonic('c');
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 2.0;
        gridBagConstraints2.insets = new Insets(18, 26, 2, 2);
        UIUtil.jGridBagAdd(jPanel2, this.antialias, gridBagConstraints2, 0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(TERM_ICON), jPanel3);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)iconWrapperPanel, "Center");
        this.loadList(TerminalEmulation.getSupportedEmulations(), this.jComboTerm, false);
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        this.fontLabel.setEnabled(this.jComboResizeStrategy.getSelectedIndex() == 2);
        this.fontSize.setEnabled(this.jComboResizeStrategy.getSelectedIndex() == 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setAvailableActions();
    }

    private void loadList(List list, JComboBox jComboBox, boolean bl) {
        Iterator iterator = list.iterator();
        if (bl) {
            jComboBox.addItem(DEFAULT);
        }
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
        String string = sshToolsConnectionProfile.getApplicationProperty("TERM", "vt100");
        int n = 0;
        while (n < this.jComboTerm.getItemCount()) {
            if (this.jComboTerm.getItemAt(n).equals(string)) {
                this.jComboTerm.setSelectedIndex(n);
                break;
            }
            ++n;
        }
        this.jComboResizeStrategy.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("RESIZE_STRATEGY", 2));
        this.jComboEOL.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("EOL", 0));
        this.jComboScreenSize.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("TERM_SCREEN_SIZE", 1));
        int n2 = sshToolsConnectionProfile.getApplicationPropertyInt("FONT_SIZE", 12);
        int n3 = 0;
        while (n3 < this.fontSize.getItemCount()) {
            if (this.fontSize.getItemAt(n3).equals(String.valueOf(n2))) {
                this.fontSize.setSelectedIndex(n3);
                break;
            }
            ++n3;
        }
        this.antialias.setSelected(sshToolsConnectionProfile.getApplicationPropertyBoolean("ANTIALIAS", false));
        this.backgroundColor.setColor(sshToolsConnectionProfile.getApplicationPropertyColor("BACKGROUND_COLOR", Color.black));
        this.foregroundColor.setColor(sshToolsConnectionProfile.getApplicationPropertyColor("FOREGROUND_COLOR", Color.white));
        this.colorPrinting.setSelected(sshToolsConnectionProfile.getApplicationPropertyBoolean("COLOR_PRINTING", false));
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Terminal";
    }

    public String getTabToolTipText() {
        return "Terminal related properties.";
    }

    public int getTabMnemonic() {
        return 116;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        this.profile.setApplicationProperty("sshterm.configured", true);
        this.profile.setApplicationProperty("TERM", (String)this.jComboTerm.getSelectedItem());
        this.profile.setApplicationProperty("RESIZE_STRATEGY", this.jComboResizeStrategy.getSelectedIndex());
        this.profile.setApplicationProperty("EOL", this.jComboEOL.getSelectedIndex());
        this.profile.setApplicationProperty("TERM_SCREEN_SIZE", this.jComboScreenSize.getSelectedIndex());
        try {
            this.profile.setApplicationProperty("FONT_SIZE", Integer.parseInt(String.valueOf(this.fontSize.getSelectedItem())));
        }
        catch (NumberFormatException numberFormatException) {
            this.profile.setApplicationProperty("FONT_SIZE", 12);
        }
        this.profile.setApplicationProperty("ANTIALIAS", this.antialias.isSelected());
        this.profile.setApplicationProperty("BACKGROUND_COLOR", this.backgroundColor.getColor());
        this.profile.setApplicationProperty("FOREGROUND_COLOR", this.foregroundColor.getColor());
        this.profile.setApplicationProperty("COLOR_PRINTING", this.colorPrinting.isSelected());
    }

    public void tabSelected() {
    }
}

