/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.util;

public class StringScanner {
    public static final char END_REACHED = '\uffff';
    protected int length = 0;
    protected int position = 0;
    protected int pos_marker = 0;
    protected char[] buffer = null;

    public StringScanner(String string) {
        this.length = string.length();
        this.buffer = new char[this.length];
        string.getChars(0, this.length, this.buffer, 0);
    }

    public boolean endReached(char c) {
        return c == '\uffff';
    }

    public boolean endNotReached(char c) {
        return !this.endReached(c);
    }

    public String toString() {
        return new String(this.buffer);
    }

    public void skip(int n) {
        this.position += n;
        if (this.position < 0) {
            this.position = 0;
        }
    }

    public char peek() {
        return this.position < this.length() ? this.buffer[this.position] : (char)'\uffff';
    }

    public char nextChar() {
        char c = this.peek();
        if (this.endNotReached(c)) {
            this.skip(1);
        }
        return c;
    }

    public boolean atEnd() {
        return this.endReached(this.peek());
    }

    public boolean hasNext() {
        return !this.atEnd();
    }

    public char nextNoneWhitespaceChar() {
        char c = this.nextChar();
        while (this.endNotReached(c) && Character.isWhitespace(c)) {
            c = this.nextChar();
        }
        return c;
    }

    public int getPosition() {
        return this.position;
    }

    public void markPosition() {
        this.pos_marker = this.position;
    }

    public void restorePosition() {
        this.setPosition(this.pos_marker);
    }

    protected int length() {
        return this.length;
    }

    protected void setPosition(int n) {
        if (n >= 0 && n <= this.length()) {
            this.position = n;
        }
    }
}

