/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private Map allowedHosts = new HashMap();
    private String knownhosts;
    private boolean hostFileWriteable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractKnownHostsKeyVerification(String string) throws InvalidHostFileException {
        InputStream inputStream = null;
        try {
            if (string != null) {
                File file;
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(string, "read"));
                }
                if ((file = new File(string)).exists()) {
                    String string2;
                    inputStream = new FileInputStream(file);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                        String string3 = (String)stringTokenizer.nextElement();
                        String string4 = (String)stringTokenizer.nextElement();
                        String string5 = (String)stringTokenizer.nextElement();
                        SshPublicKey sshPublicKey = SshKeyPairFactory.decodePublicKey(Base64.decode(string5));
                        this.putAllowedKey(string3, sshPublicKey);
                    }
                    bufferedReader.close();
                    this.hostFileWriteable = file.canWrite();
                } else {
                    file.getParentFile().mkdirs();
                    if (file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(this.toString().getBytes());
                        fileOutputStream.close();
                        this.hostFileWriteable = true;
                    } else {
                        this.hostFileWriteable = false;
                    }
                }
                if (!this.hostFileWriteable) {
                    log.warn((Object)"Host file is not writeable.");
                }
                this.knownhosts = string;
            }
        }
        catch (AccessControlException accessControlException) {
            this.hostFileWriteable = false;
            log.warn((Object)"Not enough permission to load a hosts file, so just creating an empty list");
        }
        catch (IOException iOException) {
            this.hostFileWriteable = false;
            log.info((Object)("Could not open or read " + string + ": " + iOException.getMessage()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String string, SshPublicKey sshPublicKey, boolean bl) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allowing " + string + " with fingerprint " + sshPublicKey.getFingerprint()));
        }
        this.putAllowedKey(string, sshPublicKey);
        if (bl) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public void removeAllowedHost(String string) {
        Iterator iterator = this.allowedHosts.keySet().iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (!string2.equals(string)) continue;
                this.allowedHosts.remove(string2);
            }
        }
    }

    public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        String string2 = sshPublicKey.getFingerprint();
        log.info((Object)("Verifying " + string + " host key"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fingerprint: " + string2));
        }
        Iterator iterator = this.allowedHosts.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3.equals(string)) {
                return this.validateHost(string3, sshPublicKey);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                if (!string4.equalsIgnoreCase(string)) continue;
                return this.validateHost(string3, sshPublicKey);
            }
        }
        this.onUnknownHost(string, sshPublicKey);
        return this.checkKey(string, sshPublicKey);
    }

    private boolean validateHost(String string, SshPublicKey sshPublicKey) throws TransportProtocolException {
        SshPublicKey sshPublicKey2 = this.getAllowedKey(string, sshPublicKey.getAlgorithmName());
        if (sshPublicKey2 != null && sshPublicKey.equals(sshPublicKey2)) {
            return true;
        }
        if (sshPublicKey2 == null) {
            this.onUnknownHost(string, sshPublicKey);
        } else {
            this.onHostKeyMismatch(string, sshPublicKey2, sshPublicKey);
        }
        return this.checkKey(string, sshPublicKey);
    }

    private boolean checkKey(String string, SshPublicKey sshPublicKey) {
        SshPublicKey sshPublicKey2 = this.getAllowedKey(string, sshPublicKey.getAlgorithmName());
        return sshPublicKey2 != null && sshPublicKey2.equals(sshPublicKey);
    }

    private SshPublicKey getAllowedKey(String string, String string2) {
        if (this.allowedHosts.containsKey(string)) {
            Map map = (Map)this.allowedHosts.get(string);
            return (SshPublicKey)map.get(string2);
        }
        return null;
    }

    private void putAllowedKey(String string, SshPublicKey sshPublicKey) {
        if (!this.allowedHosts.containsKey(string)) {
            this.allowedHosts.put(string, new HashMap());
        }
        Map map = (Map)this.allowedHosts.get(string);
        map.put(sshPublicKey.getAlgorithmName(), sshPublicKey);
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)("Saving " + defaultHostFile));
        try {
            File file = new File(this.knownhosts);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.knownhosts);
        }
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.allowedHosts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                SshPublicKey sshPublicKey = (SshPublicKey)entry2.getValue();
                string = string + entry.getKey().toString() + " " + sshPublicKey.getAlgorithmName() + " " + Base64.encodeBytes(sshPublicKey.getEncoded(), true) + "\n";
            }
        }
        return string;
    }

    static {
        log = LogFactory.getLog((Class)HostKeyVerification.class);
    }
}

