/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.IOException;

public class SimpleASNReader {
    private byte[] data;
    private int offset;

    public SimpleASNReader(byte[] byArray) {
        this.data = byArray;
        this.offset = 0;
    }

    public void assertByte(int n) throws IOException {
        int n2 = this.getByte();
        if (n2 != n) {
            throw new IOException("Assertion failed, next byte value is " + Integer.toHexString(n2) + " instead of asserted " + Integer.toHexString(n));
        }
    }

    public int getByte() {
        return this.data[this.offset++] & 0xFF;
    }

    public byte[] getData() {
        int n = this.getLength();
        return this.getData(n);
    }

    public int getLength() {
        int n;
        if (((n = this.data[this.offset++] & 0xFF) & 0x80) != 0) {
            int n2 = 0;
            for (int i = n & 0x7F; i > 0; --i) {
                n2 <<= 8;
                n2 |= this.data[this.offset++] & 0xFF;
            }
            return n2;
        }
        return n;
    }

    private byte[] getData(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.offset, byArray, 0, n);
        this.offset += n;
        return byArray;
    }

    public boolean hasMoreData() {
        return this.offset < this.data.length;
    }
}

